//%attributes = {"publishedSql":true}
// Method: _tcp_ AuthorizeAction
// 2004.05.07-13:57:45 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// Check HTTP authorizations

// $1 -> SocketRef
// $2 -> HTTP request
// $3 -> URL requested
// $0   =0=do UNAUTHORIZED_SEND; 1 = no access; >0 if authorized, action returned

// Ex: $ok := _tcp_ AuthorizeAction(socket;request;url)

//0 = UNAUTHORIZED_SEND
//      <>_tcp_atpopRealmAction{1}:=_lang Current ("Reject")
//      <>_tcp_atpopRealmAction{2}:=_lang Current ("Allow")
//      <>_tcp_atpopRealmAction{3}:=_lang Current ("Redirect")
//      <>_tcp_atpopRealmAction{4}:=_lang Current ("Execute")
//      <>_tcp_atpopRealmAction{5}:=_lang Current ("Web Method")      
// ------------------------------------------------------------
// COMPILER__tcp_ , COMPILER__tcp_ip

C_LONGINT:C283($0; $1; $_tcp_lIndex; $_tcp_lCount; $_tcp_lAcceptIndex; $_tcp_lTrace)
C_TEXT:C284($2; $3; _tcp_tUrl; $_tcp_tUserId; $_tcp_tPassword; $_tcp_tRealmId; _tcp_tRealmId)

$_tcp_lAuthorizeAction:=2
$_tcp_lAcceptIndex:=1
$_tcp_tRealmId:=""
$_tcp_tPassword:=""
$_tcp_tUserId:=""
$_tcp_lTrace:=kTrue
_tcp_tUserId:=""
_tcp_tPassword:=""
_tcp_tAuthorizeParameter:=""

// Check if the requested URL is in a Realm
_tcp_tUrl:=$2
_tcp_tRealmId:=_tcp_tUrl

$_tcp_lCount:=Size of array:C274(<>_tcp_atRealmURL)
For ($_tcp_lIndex; 1; $_tcp_lCount)
	If (_tcp_tUrl=(<>_tcp_atRealmURL{$_tcp_lIndex}))
		$_tcp_tRealmId:=<>_tcp_atRealmId{$_tcp_lIndex}
		$_tcp_lAuthorizeAction:=<>_tcp_alRealmAction{$_tcp_lIndex}
		If (<>_tcp_alRealmAccept{$_tcp_lIndex}=kFalse)
			$_tcp_lAcceptIndex:=-1  //prevent access
			$_tcp_lIndex:=$_tcp_lCount+1  //exit loop
		Else 
			//If (◊_tcp_atRealmParameter{$_tcp_lIndex}#"")
			//_tcp_tRealmId:=◊_tcp_atRealmParameter{$_tcp_lIndex}
			//Else 
			_tcp_tRealmId:=$_tcp_tRealmId  //v11
			//End if 
			$_tcp_lAcceptIndex:=$_tcp_lIndex
			$_tcp_lIndex:=$_tcp_lCount+1
		End if 
	End if 
End for 

Case of 
	: ($_tcp_lAcceptIndex<0)
		IDLE:C311  // URL acces restricted by realm info            
	: ($_tcp_lAcceptIndex=kFalse)  //0
		IDLE:C311  //send 401 Unauthorized -> browser asks for user & password    
	: ($_tcp_lAcceptIndex>0)  // URL acces not restricted by realm info
		// ($_http_lAccept=2)  `? 
		
		// Extract user authentification from the HTTP request
		$_tcp_tUserId64:=_http_HeaderExtract($3; "Authorization"; "")
		If ($_tcp_tUserId64="")
			IDLE:C311  // No ID given...
			If ($_tcp_tRealmId#"")  //realm empty - no restrictions
				If (Find in array:C230(<>_tcp_atUserRealms; "@"+$_tcp_tRealmId+"@")>0)
					$_tcp_lAcceptIndex:=kFalse  //send 401 Unauthorized -> browser asks for user & password
				End if 
			End if 
		Else 
			If ($_tcp_tRealmId="")
				IDLE:C311  //no realm - no restrictions        
			Else 
				Case of 
						// : (Position("Digest ";$_http_tUserId64)#0)
						// placeholder for digest authentication implementation
					: (Position:C15("Basic "; $_tcp_tUserId64)#0)
						$_tcp_tUserId64:=Substring:C12($_tcp_tUserId64; Position:C15("Basic "; $_tcp_tUserId64)+6)
						//$_tcp_tUserId64:=Replace string($_tcp_tUserId64;"=";"") `v11
						$_tcp_tUserId64:=Replace string:C233($_tcp_tUserId64; ksCR; "")
						$_tcp_tUserId:=_http_ B64ToText($_tcp_tUserId64)
						$_tcp_tPassword:=Substring:C12($_tcp_tUserId; Position:C15(":"; $_tcp_tUserId)+1)
						$_tcp_tUserId:=Substring:C12($_tcp_tUserId; 1; Position:C15(":"; $_tcp_tUserId)-1)
				End case 
				
				$_tcp_lFindPos:=0
				Repeat 
					
					$_tcp_lFind:=Find in array:C230(<>_tcp_atUserId; $_tcp_tUserId; $_tcp_lFindPos)  // look in realm os cached in <>ArUserName/<>ArUserPass/<>ArUserRealm
					If ($_tcp_lFind>0)
						$_tcp_lFindPos:=$_tcp_lFind+1
						If ((<>_tcp_atUserPassword{$_tcp_lFind}=$_tcp_tPassword) & (Position:C15($_tcp_tRealmId; <>_tcp_atUserRealms{$_tcp_lFind})>0))
							$_tcp_lAcceptIndex:=<>_tcp_alUserAccept{$_tcp_lFind}
							If ($_tcp_lAcceptIndex=kTrue)
								<>_tcp_alUserTick{$_tcp_lFind}:=Tickcount:C458
								$_tcp_lFindPos:=Size of array:C274(<>_tcp_atUserId)+1  //end repeat loop            
							End if 
							$_tcp_lTrace:=<>_tcp_alUserTrace{$_tcp_lFind}
						Else 
							$_tcp_lAcceptIndex:=kFalse
						End if 
					Else 
						$_tcp_lAcceptIndex:=kFalse  //user not found            
						$_tcp_lFindPos:=Size of array:C274(<>_tcp_atUserId)+1  //end repeat loop
					End if 
					
				Until ($_tcp_lFindPos>Size of array:C274(<>_tcp_atUserId))
			End if 
		End if 
	Else 
		TRACE:C157  //error
		_err MESSAGE(_lang Current("Unknown authorize return value"); Current method name:C684; kFalse)
End case 

_tcp_tUserId:=$_tcp_tUserId
_tcp_tPassword:=$_tcp_tPassword
_tcp_tAuthorizeParameter:=_tcp_tRealmId

If ($_tcp_lAcceptIndex=kFalse)
	$0:=0  //send 401 Unauthorized -> browser asks for user & password    
Else 
	$0:=$_tcp_lAuthorizeAction
End if 
